/* ====================================================================================
 * OGG-Player-Board
 * ====================================================================================
 * 
 * Ogg file player with 4 contole buttons based on the VS1000 Audio Module.
 * Button 1 next song
 * Button 2 pause and play
 * Button 3 volumen +
 * Button 4 volumen -
 *
 * ====================================================================================
 * VS1000 Audio Module - Version 0.41, 2010-11-09
 * 
 * The continuous playing mode understands the following single-byte commands:
 * 
 * f - switch to file play mode
 * c - switch to continuous play mode
 * C - cancel play, return to play loop, responds with c
 * + - volume up, responds with two-byte current volume level
 * - - volume down, responds with two-byte current volume level
 * = - pause on, responds with =
 * > - play (normal speed), responds with >
 * (0xbb) - faster play, responds with the new play speed
 * n - next song, responds with n
 * p - previous song, responds with p
 * ? - info, returns play seconds (4 bytes, high byte first), and one-byte file left indicator (255 to 0).
 *
 * In file play mode files are not played automatically.
 * To change into file play mode, send f, then you can send C to cancel playback.
 * The file play mode commands are single-line commands
 * ending with the newline character (0x0a).
 * The following commands are currently implemented:
 * 
 * OFF\n - powers down
 * c\n - switch to continuous play mode
 * L\n - list files
 * PFILENAMEOGG\n - play file by name, must be 8.3-character uppercase name without the ”.” .
 * pnumber\n - play file by number
 * Continuous play mode commands are available during the playing of the song.
 * http://www.vlsi.fi/en/products/vs1000module.html
 *
 * ====================================================================================
 * http://dernulleffekt.de/   09_2012
 * ==================================================================================== 
 */

int LED = 13;     
int Button1 = 4; 
int Button2 = 5; 
int Button3 = 6; 
int Button4 = 7; 
int Button1Mode;
int Button2Mode;
int Button3Mode;
int Button4Mode;
byte Song = 0;
int PlayMode = 1;
int Tracks = 17;    // Number of tracks on the SD Card

void setup()
{
  pinMode(LED, OUTPUT);
  digitalWrite(LED, HIGH);
  
  Serial.begin(115200);     // open serial communikation
  delay(500);               // wait for the audio module to start
  Serial.println("f");      // f for file play mode
  Serial.println("n");      // n for stop
  
  pinMode(Button1, INPUT);
  pinMode(Button2, INPUT);
  pinMode(Button3, INPUT);
  pinMode(Button4, INPUT);
  digitalWrite(LED, LOW);
}

void loop() {
  Button1Mode = digitalRead(Button1);         
  Button2Mode = digitalRead(Button2); 
  Button3Mode = digitalRead(Button3);  
  Button4Mode = digitalRead(Button4);   

  // next song
  if (Button1Mode == HIGH){
    digitalWrite(LED, HIGH);
    Serial.println("n");
    delay(500);
    Serial.print("p");
    Serial.print(Song);
    Serial.print("\n");
    if (Song < Tracks - 1){
      Song = Song + 1;
    }
    else if (Song = Tracks - 1){
      Song = 0;
    }
    digitalWrite(LED, LOW);
  }

  // play and pause
  if ((Button2Mode == HIGH)&& (PlayMode == 1)){
    Serial.println("=");
    PlayMode = 0;
    digitalWrite(LED, HIGH);
    delay(500);
    digitalWrite(LED, LOW);
  }
  else if ((Button2Mode == HIGH)&& (PlayMode == 0)){
    Serial.println(">");
    PlayMode = 1;
    digitalWrite(LED, HIGH);
    delay(500);
    digitalWrite(LED, LOW);
  }

  // volume
  if (Button3Mode == HIGH){
    Serial.println("+");
    delay(200);
  }
  if (Button4Mode == HIGH){
    Serial.println("-");
    delay(200);
  }
}


