/********************************************************
   Paper Bit - 8 Step Sequenzer
   for an Atmega328
   
   by Wolfgang Spahn   17Aug2016

 *********************************************************/


// Maximum of the step poti (use 5 digit less then you measured)
int StepMax = 490;

int StepLEDs[8] =  {18, 13, 11, 10, 7, 5, 3, 4};  // all 8 LED pins
int StepButtons[8] = {19, 17, 12, 9, 8, 1, 2, 0}; // all 8 button pins
int CV_Values[8] = {0, 0, 0, 0, 0, 0, 0, 0};      // Voltage output
float CV_Groove[8] = {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};    // length of each note

// add your grooves here - length of each note:
float CV_Groove0[8] = {1.3, 0.7, 0.7, 0.7, 1.3, 0.7, 0.7, 0.7};
float CV_Groove1[8] = {0.5, 1, 1, 1.3, 0.5, 1, 1, 1.3};
float CV_Groove2[8] = {1, 0.7, 1, 0.7, 1.5, 0.5, 0.5, 1.5};
float CV_Groove3[8] = {0.3, 0.4, 0.4, 1, 0.3, 0.4, 0.4, 1};
float CV_Groove4[8] = {1, 1, 0.3, 0.7, 1, 1, 0.3, 0.7};
float CV_Groove5[8] = {2, 1.3, 0.7, 0.7, 2, 1.3, 0.7, 0.7};
float CV_Groove6[8] = {1.3, 0.3, 0.3, 0.7, 1.3, 0.3, 0.3, 0.7};
float CV_Groove7[8] = {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};

int StepsPotiPin = A0;
int SpeedPotiPin = A1;
int CVPotiPin = A2;
int CVPin = 6;
int CV_Out = 0;

unsigned long DelayValue = 0;
int CV_Value;
int StepsPoti = 1023;
int Steps = 8;
int StepButton = 0;

unsigned long previousMillis = 0;
unsigned long currentMillis = 0;
int LEDState = LOW;

void setup() {
  // sets the spead on pin6 (just for a Atmega328 chip):
  TCCR0B = TCCR0B & 0b11111000 | 0x01;

  pinMode(CVPin, OUTPUT);
  for (int i = 0; i < 8; i++) {
    pinMode(StepLEDs[i], OUTPUT);
  }
  for (int i = 0; i < 8; i++) {
    pinMode(StepButtons[i], INPUT_PULLUP);
  }
  TestLEDs();
}

void loop() {
  for (int i = 0; i < Steps; i++) {
    LEDState = HIGH;
    digitalWrite(StepLEDs[i], LEDState);
    while (LEDState == HIGH) {
      SwitchCheck();
      //ButtonCheck();
      DelayValue = analogRead(SpeedPotiPin);
      DelayValue = map(DelayValue, 0, 1023, 5, 100000);
      DelayValue = DelayValue * CV_Groove[i];
      currentMillis = millis();
      if (currentMillis - previousMillis >= DelayValue) {
        previousMillis = currentMillis;
        LEDState = LOW;
        digitalWrite(StepLEDs[i], LEDState);
        analogWrite(CVPin, CV_Values[i]);
      }
    }
  }
}

// checks if the switch or the poti is on
void SwitchCheck() {
  StepsPoti = analogRead(StepsPotiPin);
  if (StepsPoti < 500) {
    Steps = map(StepsPoti, 0, StepMax, 1, 8);
    ButtonCheck();
  }
  else if (StepsPoti > 900) {   //535
    SelectPreset();
  }
}

// turns the LEDs on
void SwitchLED(int LEDnumber) {
  LEDnumber = LEDnumber - 1;
  if (LEDnumber < 0) {
    LEDnumber = 7;
  }
  digitalWrite(StepLEDs[LEDnumber], LEDState);

}

// checks if a button is pressed
void ButtonCheck() {
  for (int j = 0; j < 8; j++) {
    StepButton = digitalRead(StepButtons[j]);
    if (StepButton == LOW) {
      CV_Value = analogRead(CVPotiPin);
      CV_Value = map(CV_Value, 0, 1023, 0, 255);
      if (j > 0) CV_Values[j - 1] = CV_Value;
      else CV_Values[7] = CV_Value;
    }
  }
}

// assignes the groove
void SelectPreset() {
  for (int j = 0; j < 8; j++) {
    StepButton = digitalRead(StepButtons[j]);
    if (StepButton == LOW) {
      switch (j) {
        case 0:
          for (int i = 0; i < 8; i++) {
            CV_Groove [i] = CV_Groove0 [i];
          }
          break;
        case 1:
          for (int i = 0; i < 8; i++) {
            CV_Groove [i] = CV_Groove1 [i];
          }
          break;
        case 2:
          for (int i = 0; i < 8; i++) {
            CV_Groove [i] = CV_Groove2 [i];
          }
          break;
        case 3:
          for (int i = 0; i < 8; i++) {
            CV_Groove [i] = CV_Groove3 [i];
          }
          break;
        case 4:
          for (int i = 0; i < 8; i++) {
            CV_Groove [i] = CV_Groove4 [i];
          }
          break;
        case 5:
          for (int i = 0; i < 8; i++) {
            CV_Groove [i] = CV_Groove5 [i];
          }
          break;
        case 6:
          for (int i = 0; i < 8; i++) {
            CV_Groove [i] = CV_Groove6 [i];
          }
          break;
        case 7:
          for (int i = 0; i < 8; i++) {
            CV_Groove [i] = CV_Groove7 [i];
          }
          break;
      }
    }
  }
}

// testing the LEDs
void TestLEDs() {
  for (int i = 0; i < 8; i++) {
    digitalWrite(StepLEDs[i], HIGH);
  }
  delay(10000);
  for (int i = 0; i < 8; i++) {
    digitalWrite(StepLEDs[i], LOW);
  }
  delay(10000);
}

// testing the Buttons
void Buttontest() {
  for (int j = 0; j < 8; j++) {
    StepButton = digitalRead(StepButtons[j]);
    if (StepButton == LOW) {
      digitalWrite(StepLEDs[j], HIGH);
      delay(100);
    }
    for (int k = 0; k < 8; k++) {
      digitalWrite(StepLEDs[k], LOW);
    }
  }
}


